rm(list=ls())
library(mclust)
setwd("H:/My Documents/Morphometric stuff/Analysis with Eddy data")


filename <- read.table("Allshells with Eddy - For R.txt",header=T)
## Select only significant Principal components
filename <- filename[c(28:363),]
filename2 <- filename[,c(4:10)]

## Building GMM models
filenameMclust<-Mclust(filename2)
filenameMclust
plot(filenameMclust)
plot(filenameMclust,col=c("red","green","blue"),dimens=c(1,6),what="classification",ylab="Centroid Size",main=NULL)

## WRITES PROBABILITY FILES
probabilities<-filenameMclust$z
write.table(probabilities, file="probafile.txt")

## WRITES CLASSIFIER FILES
filename$CLUST<-filenameMclust$classification
filename$id <- filename$id
write.csv(filename,file="classifier mclust all shell analysis with centroid.csv",row.names = TRUE,quote=FALSE)

## Barplots
proba <- read.table("probafile.txt",header=T)
barplot(t(proba),col=c('green','red','blue'), border = NA, space = 0,xlab = "Individuals", ylab = "Admixture coefficients")

